<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="robots" content="noindex, nofollow">

		<title>Samsung AI Memory</title>

		<link rel="apple-touch-icon" sizes="180x180" href="/rs/assets/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="/rs/assets/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="/rs/assets/favicon-16x16.png">
		<link rel="manifest" href="/rs/assets/site.webmanifest">

		<link rel="stylesheet" href="/rs/assets/style/style.css" type="text/css">
	</head>
	<body>
		<div class="signup">
			<div class="signup-content">
				<img src="/rs/assets/logo.svg" class="signup-logo">

				<h1>Igra memorije</h1>
				<p class="signup-description">Igrajte našu igru memorije i isprobajte svoju brzinu, jer možda ćete baš vi biti jedan od naših dobitnika.</p>

				<form name="prijava" method="POST" action="/">
					<input type="text" name="imeprezime" placeholder="Ime i prezime" class="imeprezime" autocomplete="off">
					<input type="email" name="email" placeholder="Email adresa" class="email" autocomplete="off">
					<input type="tel" name="telefon" placeholder="Broj mobilnog telefona" class="telefon" autocomplete="off">

					<label class="checkbox">Prihvatam <a href="/rs/Nagradno takmicenje_Galaxy AI  Kiosk - Srbija - 24.2.25.docx">uslove i pravila korišćenja</a>.
						<input type="checkbox" class="uvjetikoristenja">
						<span class="checkmark"></span>
					</label>

					<button>Započni igru</button>

					<div class="error hidden">
						<p></p>
					</div>
				</form>
			</div>
		</div>
		<div class="game hidden">
			<div class="game-content">
				<div class="game-header">
					<img src="/rs/assets/logo.svg" class="game-logo">
					<div class="game-timer">
						<p>Vaš rezultat</p>
						<p class="game-currentTime">0:00</p>
					</div>
				</div>
				<div class="game-cards">

				</div>
			</div>
		</div>
		<div class="leaderboards hidden">
			<img src="/rs/assets/logo.svg" class="leaderboards-logo">

			<p class="leaderboards-currentScore text-center">Vaš trenutni rezultat: <span></span></p>
			<p class="leaderboards-currentPosition text-center">Trenutno se nalazite na <span></span>. mestu</p>
			<p class="text-center">Zaigrajte sutra ponovo</p>

			<h2>Trenutno kolo</h2>
			<div class="leaderboards-content">

			</div>
		</div>

		<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
		<script src="/rs/assets/js/required.js"></script>
	</body>
</html>
