<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class IndexController extends CI_Controller {

	public function __construct () {
		parent::__construct();
		$this->load->model('IndexModel');
	}

	public function index()
	{
	    $this->load->helper('cookie');
	    
	    $username = $this->input->post('username');
	    $password = $this->input->post('password');
	    
	    if($username && $password) {
	        if($username === 'galaxy' && $password === 'Paradigm2025.!') {
	            $cookie = array(
                    'name'   => 'loggedIn',
                    'value'  => 'galaxy2',
                    'expire' => time()+(86400*60)
                );
                set_cookie($cookie);
                
                header('Location: '.$_SERVER['REQUEST_URI']);
	        }
	    }
	    
	    if (is_null(get_cookie('loggedIn'))) {
	        $this->load->view('login');
	    } else if(get_cookie('loggedIn') !== 'galaxy2') {
	        $this->load->view('login');
	    } else {
	        $entries = $this->IndexModel->fetchEntries();
    		$data = [
    			'trenutni_krug' => $this->IndexModel->getTrenutniKrug(),
    			'entries' => $entries,
    		];
    
    		$this->load->view('index', $data);
	    }
	}
	
	public function stats()
	{
	    $this->load->helper('cookie');
	    
	    $username = $this->input->post('username');
	    $password = $this->input->post('password');
	    
	    if($username && $password) {
	        if($username === 'galaxy' && $password === 'Paradigm2025.!') {
	            $cookie = array(
                    'name'   => 'loggedIn',
                    'value'  => 'galaxy2',
                    'expire' => time()+(86400*60)
                );
                set_cookie($cookie);
                
                header('Location: '.$_SERVER['REQUEST_URI']);
	        }
	    }
	    
	    if (is_null(get_cookie('loggedIn'))) {
	        $this->load->view('login');
	    } else if(get_cookie('loggedIn') !== 'galaxy2') {
	        $this->load->view('login');
	    } else {
	        $stats = $this->IndexModel->fetchStats();
    		$data = [
    			'stats' => $stats,
    		];
    
    		$this->load->view('stats', $data);
	    }
	}

	public function leaderboards()
	{
		$trenutni_krug = $trenutni_krug = $this->IndexModel->getTrenutniKrug(true);
		$entries = $this->IndexModel->fetchEntries();

		$response['html'] = '';

		if(!empty($entries[$trenutni_krug])) {
			$response['html'] .= '<table>
				<thead>
					<tr>
						<th>Mesto</th>
						<th>Ime in priimek</th>
						<th>Rezultat</th>
					</tr>
				</thead>
				<tbody>';
				
				$mjesto = 1;
				foreach($entries[$trenutni_krug] as $entry) {
				    $vrijeme = round($entry['vrijeme'] / 1000, 2);
					$minutes = floor($vrijeme / 60);
					$seconds = round(fmod($vrijeme, 60), 2);

					if ($seconds < 10) {
						$seconds = "0".$seconds;
					}
					
					$response['html'] .= '<tr>
						<td>'.$mjesto.'</td>
						<td>'.$entry['imeprezime'].'</td>
						<td>'.$minutes.':'.$seconds.'</td>
					</tr>';
					
					$mjesto++;
				}
				
				$response['html'] .= '</tbody>
									</table>';
		} else {
			$response['html'] .= '<p>Nema prijava</p>';
		}

		for($i = $trenutni_krug - 1; $i >= 1; $i--) {
			if(!empty($entries[$i])) {
				$krug_datumi = '';
				switch($i) {
					case 1:
						$krug_datumi = '3. februar - 7. februar 2025';
						break;
					case 2:
						$krug_datumi = '11. - 15. februar 2025';
						break;
					case 3:
						$krug_datumi = '18. - 22. februar 2025';
						break;
					case 4:
						$krug_datumi = '25. februar - 1. marec 2025';
						break;
					case 5:
						$krug_datumi = '4. - 8. marec 2025';
						break;
					case 6:
						$krug_datumi = '11. - 15. marec 2025';
						break;
				}
				
				$response['html'] .= '<h3>'.$i.'. krog / '.$krug_datumi.'</h3>
									<table>
										<thead>
											<tr>
												<th>Mesto</th>
												<th>Ime in priimek</th>
												<th>Rezultat</th>
											</tr>
										</thead>
										<tbody>';
				$mjesto = 1;

				foreach($entries[$i] as $entry) {
				    $vrijeme = round($entry['vrijeme'] / 1000, 2);
					$minutes = floor($vrijeme / 60);
					$seconds = round(fmod($vrijeme, 60), 2);

					if ($seconds < 10) {
						$seconds = "0".$seconds;
					}
					
					$response['html'] .= '<tr>
						<td>'.$mjesto.'</td>
						<td>'.$entry['imeprezime'].'</td>
						<td>'.$minutes.':'.$seconds.'</td>
					</tr>';
					$mjesto++;
				}
				
				$response['html'] .= '</tbody>
									</table>';
			}
		}

		echo json_encode($response);
	}
	
	public function results()
	{
		$trenutni_krug = $trenutni_krug = $this->IndexModel->getTrenutniKrug(true);
		$entries = $this->IndexModel->fetchEntries();

		$response['html'] = '';

		if(!empty($entries[$trenutni_krug])) {
			$response['html'] .= '<table>
				<thead>
					<tr>
						<th>Mesto</th>
						<th>Ime in priimek</th>
						<th>Rezultat</th>
					</tr>
				</thead>
				<tbody>';
				
				$mjesto = 1;
				foreach($entries[$trenutni_krug] as $entry) {
					$vrijeme = round($entry['vrijeme'] / 1000, 2);
					$minutes = floor($vrijeme / 60);
					$seconds = round(fmod($vrijeme, 60), 2);

					if ($seconds < 10) {
						$seconds = "0".$seconds;
					}

					$response['html'] .= '<tr>
						<td>'.$mjesto.'</td>
						<td>'.$entry['imeprezime'].'</td>
						<td>'.$minutes.':'.$seconds.'</td>
					</tr>';
					
					$mjesto++;
				}
				
				$response['html'] .= '</tbody>
									</table>';
		} else {
			$response['html'] .= '<p style="margin-bottom: 50px;">Rezultatov ni</p>';
		}

		for($i = $trenutni_krug - 1; $i >= 1; $i--) {
			if(!empty($entries[$i])) {
				$krug_datumi = '';
				switch($i) {
					case 1:
						$krug_datumi = '3. februar - 7. februar 2025';
						break;
					case 2:
						$krug_datumi = '11. - 15. februar 2025';
						break;
					case 3:
						$krug_datumi = '18. - 22. februar 2025';
						break;
					case 4:
						$krug_datumi = '25. februar - 1. marec 2025';
						break;
					case 5:
						$krug_datumi = '4. - 8. marec 2025';
						break;
					case 6:
						$krug_datumi = '11. - 15. marec 2025';
						break;
				}
				
				$response['html'] .= '<h3>'.$i.'. kolo / '.$krug_datumi.'</h3>
									<table>
										<thead>
											<tr>
												<th>Mesto</th>
												<th>Ime in priimek</th>
												<th>Rezultat</th>
											</tr>
										</thead>
										<tbody>';
				$mjesto = 1;

				foreach($entries[$i] as $entry) {
					$vrijeme = round($entry['vrijeme'] / 1000, 2);
					$minutes = floor($vrijeme / 60);
					$seconds = round(fmod($vrijeme, 60), 2);

					if ($seconds < 10) {
						$seconds = "0" + $seconds;
					}

					$response['html'] .= '<tr>
						<td>'.$mjesto.'</td>
						<td>'.$entry['imeprezime'].'</td>
						<td>'.$minutes.':'.$seconds.'</td>
					</tr>';
					$mjesto++;
				}
				
				$response['html'] .= '</tbody>
									</table>';
			}
		}

		$data = [
			'results' => $response['html'],
		];

		$this->load->view('results', $data);
	}

	public function canParticipate() {
		$response['status'] = 'error';
		$response['message'] = 'Došlo je do pogreške.';

		$email = $this->input->post('email');

		if($this->IndexModel->canParticipate($email)) {
			$response['status'] = 'success';
			$response['message'] = 'Uspjeh';
			echo json_encode($response);
			exit;
		}

		echo json_encode($response);
		exit;
	}

	public function insert() {
		$response['status'] = 'error';
		$response['message'] = 'Došlo je do pogreške.';

		// XSS filter
		$participantData = $this->input->post(NULL, TRUE);
		if (!$participantData) {
			echo json_encode($response);
			exit;
		}

		$imeprezime = $this->input->post('imeprezime');
		$email = $this->input->post('email');
		$telefon = $this->input->post('telefon');
		$vrijeme = $this->input->post('vrijeme');

		if (!$imeprezime || !$email || !$telefon || !$vrijeme) {
			echo json_encode($response);
			exit;
		}
		
		if($this->IndexModel->canParticipate($email)) {
			$currentPosition = $this->IndexModel->insertParticipant($imeprezime, $email, $telefon, $vrijeme);

			$response['currentPosition'] = $currentPosition;
		}

		$response['status'] = 'success';
		$response['message'] = 'Uspjeh';
		echo json_encode($response);
		exit;
	}
}
